<?php
/**
 * Background Pattern Style - Tufted.
 *
 * @package Divi
 * @sub-package Builder
 * @since 4.15.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}

/**
 * Class ET_Builder_Pattern_Tufted
 *
 * @since 4.15.0
 */
class ET_Builder_Pattern_Tufted extends ET_Builder_Background_Pattern_Style_Base {
	/**
	 * Configuration.
	 *
	 * @return array
	 */
	public function settings() {
		return array(
			'label'      => esc_html__( 'Tufted', 'et-builder' ),
			'svgContent' => array(
				'default'          => '<path d="M9.85,54.15a1,1,0,0,1-.71,1.71,1,1,0,0,1-.7-.3,1,1,0,0,1,1.41-1.41ZM17.58,45a1,1,0,0,0,0,1.41,1,1,0,0,0,1.41,0A1,1,0,0,0,17.58,45Zm9.85-7.44a1,1,0,0,0,.71-.29,1,1,0,0,0,0-1.42,1,1,0,0,0-1.42,1.42A1,1,0,0,0,27.43,37.57Zm8.43-10.85a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0,1,1,0,0,0-1.42-1.42ZM45,17.58A1,1,0,0,0,45,19a1,1,0,0,0,1.41,0A1,1,0,1,0,45,17.58Zm9.14-9.14a1,1,0,0,0,0,1.41,1,1,0,0,0,1.41,0,1,1,0,1,0-1.41-1.41Zm0,109.71a1,1,0,0,0,0,1.41,1,1,0,0,0,1.41,0,1,1,0,1,0-1.41-1.41ZM45,109a1,1,0,0,0,0,1.41,1,1,0,0,0,1.41,0A1,1,0,1,0,45,109Zm-9.15-9.15a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0,1,1,0,1,0-1.42-1.42Zm-9.14-9.14a1,1,0,0,0,0,1.42,1,1,0,0,0,.71.29,1,1,0,0,0,.71-.29,1,1,0,0,0-1.42-1.42Zm-9.14-9.14a1,1,0,0,0,0,1.41A1,1,0,0,0,19,83a1,1,0,0,0-1.41-1.41ZM8.44,72.44a1,1,0,0,0,0,1.41,1,1,0,0,0,.7.29,1,1,0,0,0,.71-.29,1,1,0,0,0-1.41-1.41Zm64,45.71a1,1,0,0,0,0,1.41,1,1,0,0,0,1.41,0,1,1,0,0,0-1.41-1.41ZM81.58,109a1,1,0,0,0,0,1.41,1,1,0,0,0,1.41,0A1,1,0,0,0,81.58,109Zm9.14-9.15a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0,1,1,0,1,0-1.42-1.42Zm9.14-9.14a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0,1,1,0,0,0-1.42-1.42ZM109,81.58A1,1,0,0,0,109,83a1,1,0,0,0,1.41,0A1,1,0,0,0,109,81.58Zm9.14-9.15a1,1,0,0,0,0,1.42,1,1,0,0,0,1.41,0,1,1,0,0,0-1.41-1.42Zm0-18.28a1,1,0,0,0,0,1.41,1,1,0,1,0,1.41-1.41A1,1,0,0,0,118.15,54.15ZM109,45a1,1,0,0,0,0,1.41,1,1,0,0,0,1.41,0A1,1,0,0,0,109,45Zm-9.15-9.15a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0,1,1,0,0,0-1.42-1.42Zm-8.43-7.43a1,1,0,0,0,.7-.3,1,1,0,1,0-.7.3ZM81.58,17.58a1,1,0,0,0,0,1.41A1,1,0,0,0,83,19a1,1,0,1,0-1.41-1.41ZM72.44,8.44a1,1,0,0,0,.7,1.7,1,1,0,0,0,.71-.29,1,1,0,0,0,0-1.41A1,1,0,0,0,72.44,8.44ZM64,3a3.15,3.15,0,0,0,2.13-.87A3.13,3.13,0,0,0,67,0H61a3.13,3.13,0,0,0,.87,2.12A3.15,3.15,0,0,0,64,3ZM3,64a3.15,3.15,0,0,0-.87-2.13A3.07,3.07,0,0,0,0,61v6a3.15,3.15,0,0,0,2.13-.87A3.15,3.15,0,0,0,3,64Zm63.13,61.87A3,3,0,0,0,61,128h6A3.15,3.15,0,0,0,66.13,125.86Zm59.11-63A3,3,0,0,0,125,64a3,3,0,0,0,3,3V61a2.86,2.86,0,0,0-2.76,1.85Z"/>',
				'default-inverted' => '<path d="M67,0a3.13,3.13,0,0,1-.87,2.12A3.15,3.15,0,0,1,64,3a3.15,3.15,0,0,1-2.13-.87A3.13,3.13,0,0,1,61,0H0V61a3.07,3.07,0,0,1,2.13.83A3.15,3.15,0,0,1,3,64a3.15,3.15,0,0,1-.87,2.13A3.15,3.15,0,0,1,0,67v61H61a3,3,0,1,1,6,0h61V67a3,3,0,0,1-3-3,3,3,0,0,1,.24-1.14A2.86,2.86,0,0,1,128,61V0ZM26.72,35.86a1,1,0,0,1,1.42,0,1,1,0,0,1,0,1.42,1,1,0,0,1-.71.29,1,1,0,0,1-.71-.29A1,1,0,0,1,26.72,35.86Zm-16.87,38a1,1,0,0,1-.71.29,1,1,0,0,1-.7-.29,1,1,0,1,1,1.41,0Zm0-18.29a1,1,0,0,1-.71.3,1,1,0,0,1-.7-.3,1,1,0,1,1,1.41,0ZM19,83a1,1,0,0,1-1.41,0A1,1,0,1,1,19,83Zm0-36.57a1,1,0,0,1-1.41,0,1,1,0,1,1,1.41,0Zm9.15,45.72a1,1,0,0,1-.71.29,1,1,0,0,1-.71-.29,1,1,0,1,1,1.42,0Zm9.14,9.14a1,1,0,0,1-1.42,0,1,1,0,1,1,1.42,0Zm0-73.14a1,1,0,0,1-1.42,0,1,1,0,1,1,1.42,0Zm9.14,82.28a1,1,0,0,1-1.41,0,1,1,0,1,1,1.41,0Zm0-91.43A1,1,0,0,1,45,19a1,1,0,1,1,1.41,0Zm9.14,100.57a1,1,0,0,1-1.41,0,1,1,0,1,1,1.41,0Zm0-109.71a1,1,0,0,1-1.41,0,1,1,0,1,1,1.41,0ZM90.72,26.72a1,1,0,1,1,1.41,1.41,1,1,0,0,1-.7.3,1,1,0,0,1-.71-1.71ZM73.85,119.56a1,1,0,0,1-1.41,0,1,1,0,1,1,1.41,0Zm0-109.71a1,1,0,0,1-.71.29,1,1,0,0,1-.7-1.7,1,1,0,0,1,1.41,0A1,1,0,0,1,73.85,9.85ZM83,110.42a1,1,0,0,1-1.41,0,1,1,0,1,1,1.41,0ZM83,19a1,1,0,0,1-1.41,0A1,1,0,1,1,83,19Zm9.15,82.29a1,1,0,0,1-1.42,0,1,1,0,1,1,1.42,0Zm9.14-9.14a1,1,0,0,1-1.42,0,1,1,0,1,1,1.42,0Zm0-54.86a1,1,0,0,1-1.42,0,1,1,0,1,1,1.42,0ZM110.42,83A1,1,0,0,1,109,83a1,1,0,1,1,1.41,0Zm0-36.57a1,1,0,0,1-1.41,0,1,1,0,1,1,1.41,0Zm9.14,27.43a1,1,0,0,1-1.41,0,1,1,0,0,1,0-1.42,1,1,0,0,1,1.41,1.42Zm0-18.29a1,1,0,0,1-1.41,0,1,1,0,0,1,1.41-1.41A1,1,0,0,1,119.56,55.56Z"/>',
				'rotated'          => '<path d="M9.85,54.15a1,1,0,0,1-.71,1.71,1,1,0,0,1-.7-.3,1,1,0,0,1,1.41-1.41ZM17.58,45a1,1,0,0,0,0,1.41,1,1,0,0,0,1.41,0A1,1,0,0,0,17.58,45Zm9.85-7.44a1,1,0,0,0,.71-.29,1,1,0,0,0,0-1.42,1,1,0,0,0-1.42,1.42A1,1,0,0,0,27.43,37.57Zm8.43-10.85a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0,1,1,0,0,0-1.42-1.42ZM45,17.58A1,1,0,0,0,45,19a1,1,0,0,0,1.41,0A1,1,0,1,0,45,17.58Zm9.14-9.14a1,1,0,0,0,0,1.41,1,1,0,0,0,1.41,0,1,1,0,1,0-1.41-1.41Zm0,109.71a1,1,0,0,0,0,1.41,1,1,0,0,0,1.41,0,1,1,0,1,0-1.41-1.41ZM45,109a1,1,0,0,0,0,1.41,1,1,0,0,0,1.41,0A1,1,0,1,0,45,109Zm-9.15-9.15a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0,1,1,0,1,0-1.42-1.42Zm-9.14-9.14a1,1,0,0,0,0,1.42,1,1,0,0,0,.71.29,1,1,0,0,0,.71-.29,1,1,0,0,0-1.42-1.42Zm-9.14-9.14a1,1,0,0,0,0,1.41A1,1,0,0,0,19,83a1,1,0,0,0-1.41-1.41ZM8.44,72.44a1,1,0,0,0,0,1.41,1,1,0,0,0,.7.29,1,1,0,0,0,.71-.29,1,1,0,0,0-1.41-1.41Zm64,45.71a1,1,0,0,0,0,1.41,1,1,0,0,0,1.41,0,1,1,0,0,0-1.41-1.41ZM81.58,109a1,1,0,0,0,0,1.41,1,1,0,0,0,1.41,0A1,1,0,0,0,81.58,109Zm9.14-9.15a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0,1,1,0,1,0-1.42-1.42Zm9.14-9.14a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0,1,1,0,0,0-1.42-1.42ZM109,81.58A1,1,0,0,0,109,83a1,1,0,0,0,1.41,0A1,1,0,0,0,109,81.58Zm9.14-9.15a1,1,0,0,0,0,1.42,1,1,0,0,0,1.41,0,1,1,0,0,0-1.41-1.42Zm0-18.28a1,1,0,0,0,0,1.41,1,1,0,1,0,1.41-1.41A1,1,0,0,0,118.15,54.15ZM109,45a1,1,0,0,0,0,1.41,1,1,0,0,0,1.41,0A1,1,0,0,0,109,45Zm-9.15-9.15a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0,1,1,0,0,0-1.42-1.42Zm-8.43-7.43a1,1,0,0,0,.7-.3,1,1,0,1,0-.7.3ZM81.58,17.58a1,1,0,0,0,0,1.41A1,1,0,0,0,83,19a1,1,0,1,0-1.41-1.41ZM72.44,8.44a1,1,0,0,0,.7,1.7,1,1,0,0,0,.71-.29,1,1,0,0,0,0-1.41A1,1,0,0,0,72.44,8.44ZM64,3a3.15,3.15,0,0,0,2.13-.87A3.13,3.13,0,0,0,67,0H61a3.13,3.13,0,0,0,.87,2.12A3.15,3.15,0,0,0,64,3ZM3,64a3.15,3.15,0,0,0-.87-2.13A3.07,3.07,0,0,0,0,61v6a3.15,3.15,0,0,0,2.13-.87A3.15,3.15,0,0,0,3,64Zm63.13,61.87A3,3,0,0,0,61,128h6A3.15,3.15,0,0,0,66.13,125.86Zm59.11-63A3,3,0,0,0,125,64a3,3,0,0,0,3,3V61a2.86,2.86,0,0,0-2.76,1.85Z"/>',
				'rotated-inverted' => '<path d="M67,0a3.13,3.13,0,0,1-.87,2.12A3.15,3.15,0,0,1,64,3a3.15,3.15,0,0,1-2.13-.87A3.13,3.13,0,0,1,61,0H0V61a3.07,3.07,0,0,1,2.13.83A3.15,3.15,0,0,1,3,64a3.15,3.15,0,0,1-.87,2.13A3.15,3.15,0,0,1,0,67v61H61a3,3,0,1,1,6,0h61V67a3,3,0,0,1-3-3,3,3,0,0,1,.24-1.14A2.86,2.86,0,0,1,128,61V0ZM26.72,35.86a1,1,0,0,1,1.42,0,1,1,0,0,1,0,1.42,1,1,0,0,1-.71.29,1,1,0,0,1-.71-.29A1,1,0,0,1,26.72,35.86Zm-16.87,38a1,1,0,0,1-.71.29,1,1,0,0,1-.7-.29,1,1,0,1,1,1.41,0Zm0-18.29a1,1,0,0,1-.71.3,1,1,0,0,1-.7-.3,1,1,0,1,1,1.41,0ZM19,83a1,1,0,0,1-1.41,0A1,1,0,1,1,19,83Zm0-36.57a1,1,0,0,1-1.41,0,1,1,0,1,1,1.41,0Zm9.15,45.72a1,1,0,0,1-.71.29,1,1,0,0,1-.71-.29,1,1,0,1,1,1.42,0Zm9.14,9.14a1,1,0,0,1-1.42,0,1,1,0,1,1,1.42,0Zm0-73.14a1,1,0,0,1-1.42,0,1,1,0,1,1,1.42,0Zm9.14,82.28a1,1,0,0,1-1.41,0,1,1,0,1,1,1.41,0Zm0-91.43A1,1,0,0,1,45,19a1,1,0,1,1,1.41,0Zm9.14,100.57a1,1,0,0,1-1.41,0,1,1,0,1,1,1.41,0Zm0-109.71a1,1,0,0,1-1.41,0,1,1,0,1,1,1.41,0ZM90.72,26.72a1,1,0,1,1,1.41,1.41,1,1,0,0,1-.7.3,1,1,0,0,1-.71-1.71ZM73.85,119.56a1,1,0,0,1-1.41,0,1,1,0,1,1,1.41,0Zm0-109.71a1,1,0,0,1-.71.29,1,1,0,0,1-.7-1.7,1,1,0,0,1,1.41,0A1,1,0,0,1,73.85,9.85ZM83,110.42a1,1,0,0,1-1.41,0,1,1,0,1,1,1.41,0ZM83,19a1,1,0,0,1-1.41,0A1,1,0,1,1,83,19Zm9.15,82.29a1,1,0,0,1-1.42,0,1,1,0,1,1,1.42,0Zm9.14-9.14a1,1,0,0,1-1.42,0,1,1,0,1,1,1.42,0Zm0-54.86a1,1,0,0,1-1.42,0,1,1,0,1,1,1.42,0ZM110.42,83A1,1,0,0,1,109,83a1,1,0,1,1,1.41,0Zm0-36.57a1,1,0,0,1-1.41,0,1,1,0,1,1,1.41,0Zm9.14,27.43a1,1,0,0,1-1.41,0,1,1,0,0,1,0-1.42,1,1,0,0,1,1.41,1.42Zm0-18.29a1,1,0,0,1-1.41,0,1,1,0,0,1,1.41-1.41A1,1,0,0,1,119.56,55.56Z"/>',
				'thumbnail'        => '<path d="M12.31,27.69a.24.24,0,0,1-.17.4A.2.2,0,0,1,12,28a.23.23,0,1,1,.33-.33ZM12,2a.24.24,0,0,0,.16.4.28.28,0,0,0,.17-.07.24.24,0,0,0,0-.33A.22.22,0,0,0,12,2Zm2.14,23.57a.24.24,0,0,0,0,.33.22.22,0,0,0,.17.07.2.2,0,0,0,.16-.07.23.23,0,1,0-.33-.33ZM5.55,4.12a.24.24,0,0,0,0,.33.2.2,0,0,0,.16.07.22.22,0,0,0,.17-.07.23.23,0,0,0-.33-.33Zm4,25.38a.7.7,0,0,0-.2.5h0a.74.74,0,0,0,.2.5.72.72,0,0,0,1,0,.79.79,0,0,0,.2-.5h0a.7.7,0,0,0-.2-.5A.74.74,0,0,0,9.5,29.5ZM7.69,27.69a.24.24,0,0,0,.17.4A.2.2,0,0,0,8,28a.23.23,0,1,0-.33-.33ZM14.12,4.12a.24.24,0,0,0,0,.33.22.22,0,0,0,.17.07.2.2,0,0,0,.16-.07.23.23,0,1,0-.33-.33ZM7.69,2a.24.24,0,0,0,.17.4A.2.2,0,0,0,8,2.31.23.23,0,1,0,7.69,2Zm15,15a.24.24,0,0,0,.17.4.2.2,0,0,0,.16-.07.23.23,0,0,0-.33-.33Zm0-4.29a.24.24,0,0,0,.17.4A.2.2,0,0,0,23,13a.22.22,0,0,0,0-.33A.24.24,0,0,0,22.69,12.69Zm-2.14-2.14a.24.24,0,0,0,0,.33.2.2,0,0,0,.16.07.22.22,0,0,0,.17-.07.23.23,0,1,0-.33-.33Zm0,8.57a.24.24,0,0,0,0,.33.2.2,0,0,0,.16.07.22.22,0,0,0,.17-.07.23.23,0,0,0-.33-.33ZM18.4,21.26a.25.25,0,0,0,0,.34.27.27,0,0,0,.34,0,.24.24,0,1,0-.34-.34ZM16.26,23.4a.25.25,0,0,0,0,.34.24.24,0,0,0,.34,0,.24.24,0,0,0-.34-.34Zm2.14-15a.25.25,0,0,0,0,.34.24.24,0,0,0,.34,0,.24.24,0,1,0-.34-.34ZM10,.7a.77.77,0,0,0,.5-.2.79.79,0,0,0,.2-.5H9.3a.74.74,0,0,0,.2.5A.77.77,0,0,0,10,.7ZM1.43,8.81a.28.28,0,0,0,.17-.07.27.27,0,0,0,0-.34.24.24,0,0,0-.34.34A.28.28,0,0,0,1.43,8.81Zm15-2.15a.2.2,0,0,0,.16-.07.23.23,0,1,0-.16.07ZM5.55,25.55a.24.24,0,0,0,0,.33.2.2,0,0,0,.16.07.22.22,0,0,0,.17-.07.23.23,0,1,0-.33-.33ZM1.26,21.26a.25.25,0,0,0,0,.34.27.27,0,0,0,.34,0,.24.24,0,1,0-.34-.34ZM3.4,23.4a.25.25,0,0,0,0,.34.24.24,0,0,0,.34,0,.24.24,0,0,0-.34-.34Zm0-17.14a.25.25,0,0,0,0,.34.27.27,0,0,0,.34,0,.24.24,0,1,0-.34-.34ZM42,27.69A.24.24,0,0,0,42,28a.2.2,0,0,0,.16.07.23.23,0,1,0-.16-.4Zm2.14-2.14a.24.24,0,0,0,0,.33.22.22,0,0,0,.17.07.2.2,0,0,0,.16-.07.23.23,0,0,0-.33-.33ZM42,2a.24.24,0,0,0,.16.4.28.28,0,0,0,.17-.07.24.24,0,0,0,0-.33A.22.22,0,0,0,42,2Zm2.14,2.14a.24.24,0,0,0,0,.33.22.22,0,0,0,.17.07.2.2,0,0,0,.16-.07.23.23,0,0,0-.33-.33ZM37.69,2a.24.24,0,0,0,.17.4A.2.2,0,0,0,38,2.31.23.23,0,1,0,37.69,2Zm15,15a.24.24,0,0,0,.17.4.2.2,0,0,0,.16-.07.23.23,0,1,0-.33-.33Zm-2.14,2.14a.24.24,0,0,0,0,.33.2.2,0,0,0,.16.07.22.22,0,0,0,.17-.07.23.23,0,1,0-.33-.33ZM48.4,8.4a.25.25,0,0,0,0,.34.24.24,0,0,0,.34,0,.24.24,0,0,0-.34-.34Zm-2.14,15a.25.25,0,0,0,0,.34.24.24,0,0,0,.34,0,.24.24,0,0,0-.34-.34Zm-8.57,4.29a.24.24,0,0,0,.17.4A.2.2,0,0,0,38,28a.23.23,0,1,0-.33-.33ZM50.55,10.55a.24.24,0,0,0,0,.33.2.2,0,0,0,.16.07.22.22,0,0,0,.17-.07.23.23,0,1,0-.33-.33ZM48.4,21.26a.25.25,0,0,0,0,.34.27.27,0,0,0,.34,0,.24.24,0,1,0-.34-.34ZM39.5,29.5a.7.7,0,0,0-.2.5h0a.74.74,0,0,0,.2.5.72.72,0,0,0,1,0,.79.79,0,0,0,.2-.5h0a.7.7,0,0,0-.2-.5A.74.74,0,0,0,39.5,29.5ZM27,17a.24.24,0,0,0,0,.33.2.2,0,0,0,.16.07A.23.23,0,1,0,27,17Zm2.14,2.14a.24.24,0,0,0,0,.33.22.22,0,0,0,.17.07.2.2,0,0,0,.16-.07.23.23,0,0,0-.33-.33ZM31.43,8.81a.28.28,0,0,0,.17-.07.27.27,0,0,0,0-.34.24.24,0,1,0-.34.34A.28.28,0,0,0,31.43,8.81ZM27,12.69A.24.24,0,0,0,27,13a.2.2,0,0,0,.16.07.23.23,0,1,0-.16-.4ZM40,.7a.77.77,0,0,0,.5-.2.79.79,0,0,0,.2-.5H39.3a.74.74,0,0,0,.2.5A.77.77,0,0,0,40,.7Zm6.43,6a.2.2,0,0,0,.16-.07.23.23,0,1,0-.16.07ZM29.12,10.55a.24.24,0,0,0,0,.33.22.22,0,0,0,.17.07.2.2,0,0,0,.16-.07.23.23,0,1,0-.33-.33Zm6.43,15a.24.24,0,0,0,0,.33.2.2,0,0,0,.16.07.22.22,0,0,0,.17-.07.23.23,0,1,0-.33-.33Zm0-21.43a.24.24,0,0,0,0,.33.2.2,0,0,0,.16.07.22.22,0,0,0,.17-.07.23.23,0,1,0-.33-.33ZM33.4,6.26a.25.25,0,0,0,0,.34.27.27,0,0,0,.34,0,.24.24,0,0,0-.34-.34Zm0,17.14a.25.25,0,0,0,0,.34.24.24,0,0,0,.34,0,.24.24,0,0,0-.34-.34Zm-2.14-2.14a.25.25,0,0,0,0,.34.27.27,0,0,0,.34,0,.24.24,0,0,0-.34-.34ZM25,14.3h0a.72.72,0,0,0-.5.2.91.91,0,0,0-.15.23.86.86,0,0,0-.05.27.74.74,0,0,0,.2.5.77.77,0,0,0,.5.2h0a.77.77,0,0,0,.5-.2.74.74,0,0,0,.2-.5.7.7,0,0,0-.2-.5A.72.72,0,0,0,25,14.3Zm27.69-1.61a.24.24,0,0,0,.17.4A.2.2,0,0,0,53,13a.22.22,0,0,0,0-.33A.24.24,0,0,0,52.69,12.69Zm6.43-2.14a.24.24,0,0,0,0,.33.22.22,0,0,0,.17.07.2.2,0,0,0,.16-.07.23.23,0,0,0-.33-.33ZM76.43,6.66a.2.2,0,0,0,.16-.07.23.23,0,1,0-.16.07ZM65.55,25.55a.24.24,0,0,0,0,.33.2.2,0,0,0,.16.07.22.22,0,0,0,.17-.07.23.23,0,1,0-.33-.33Zm-6.43-6.43a.24.24,0,0,0,0,.33.22.22,0,0,0,.17.07.2.2,0,0,0,.16-.07.23.23,0,0,0-.33-.33ZM78.4,8.4a.25.25,0,0,0,0,.34.24.24,0,0,0,.34,0,.24.24,0,0,0-.34-.34Zm0,12.86a.25.25,0,0,0,0,.34.27.27,0,0,0,.34,0,.24.24,0,0,0-.34-.34ZM72,27.69A.24.24,0,0,0,72,28a.2.2,0,0,0,.16.07.23.23,0,1,0-.16-.4Zm2.14-2.14a.24.24,0,0,0,0,.33.22.22,0,0,0,.17.07.2.2,0,0,0,.16-.07.23.23,0,0,0-.33-.33Zm2.14-2.15a.25.25,0,0,0,0,.34.24.24,0,0,0,.34,0,.24.24,0,1,0-.34-.34Zm-12.86,0a.25.25,0,0,0,0,.34.24.24,0,0,0,.34,0,.24.24,0,0,0-.34-.34Zm0-17.14a.25.25,0,0,0,0,.34.27.27,0,0,0,.34,0,.24.24,0,0,0-.34-.34ZM74.12,4.12a.24.24,0,0,0,0,.33.22.22,0,0,0,.17.07.2.2,0,0,0,.16-.07.23.23,0,0,0-.33-.33ZM61.26,21.26a.25.25,0,0,0,0,.34.27.27,0,0,0,.34,0,.24.24,0,1,0-.34-.34ZM72,2a.24.24,0,0,0,.16.4.28.28,0,0,0,.17-.07.24.24,0,0,0,0-.33A.22.22,0,0,0,72,2ZM65.55,4.12a.24.24,0,0,0,0,.33.2.2,0,0,0,.16.07.22.22,0,0,0,.17-.07.23.23,0,1,0-.33-.33ZM61.43,8.81a.28.28,0,0,0,.17-.07.27.27,0,0,0,0-.34.24.24,0,0,0-.34.34A.28.28,0,0,0,61.43,8.81ZM67.69,2a.24.24,0,0,0,.17.4A.2.2,0,0,0,68,2.31.23.23,0,0,0,67.69,2Zm0,25.71a.24.24,0,0,0,.17.4A.2.2,0,0,0,68,28a.23.23,0,0,0-.33-.33ZM57,17a.24.24,0,0,0,0,.33.2.2,0,0,0,.16.07A.23.23,0,1,0,57,17ZM55,14.3h0a.72.72,0,0,0-.5.2.91.91,0,0,0-.15.23.86.86,0,0,0-.05.27.74.74,0,0,0,.2.5.77.77,0,0,0,.5.2h0a.77.77,0,0,0,.5-.2.74.74,0,0,0,.2-.5.7.7,0,0,0-.2-.5A.72.72,0,0,0,55,14.3Zm2-1.61A.24.24,0,0,0,57,13a.2.2,0,0,0,.16.07.23.23,0,1,0-.16-.4ZM69.5,29.5a.7.7,0,0,0-.2.5h0a.74.74,0,0,0,.2.5.73.73,0,0,0,1,0,.79.79,0,0,0,.2-.5h0a.7.7,0,0,0-.2-.5A.74.74,0,0,0,69.5,29.5ZM70,.7a.77.77,0,0,0,.5-.2.79.79,0,0,0,.2-.5H69.3a.74.74,0,0,0,.2.5A.77.77,0,0,0,70,.7ZM14.12,55.55a.24.24,0,0,0,0,.33.22.22,0,0,0,.17.07.2.2,0,0,0,.16-.07.23.23,0,0,0-.33-.33ZM12,32a.24.24,0,0,0,.16.4.28.28,0,0,0,.17-.07.24.24,0,0,0,0-.33A.22.22,0,0,0,12,32Zm4.45,4.68a.2.2,0,0,0,.16-.07.23.23,0,1,0-.16.07Zm2,14.6a.25.25,0,0,0,0,.34.27.27,0,0,0,.34,0,.24.24,0,1,0-.34-.34Zm2.15-2.14a.24.24,0,0,0,0,.33.2.2,0,0,0,.16.07.22.22,0,0,0,.17-.07.23.23,0,1,0-.33-.33Zm-6.43-15a.24.24,0,0,0,0,.33.22.22,0,0,0,.17.07.2.2,0,0,0,.16-.07.23.23,0,1,0-.33-.33ZM16.26,53.4a.25.25,0,0,0,0,.34.24.24,0,0,0,.34,0,.24.24,0,0,0-.34-.34Zm4.29-12.85a.24.24,0,0,0,0,.33.2.2,0,0,0,.16.07.22.22,0,0,0,.17-.07.23.23,0,0,0-.33-.33ZM1.26,51.26a.25.25,0,0,0,0,.34.27.27,0,0,0,.34,0,.24.24,0,1,0-.34-.34ZM12,57.69A.24.24,0,0,0,12,58a.2.2,0,0,0,.16.07.23.23,0,1,0-.16-.4ZM1.43,38.81a.28.28,0,0,0,.17-.07.27.27,0,0,0,0-.34.24.24,0,0,0-.34.34A.28.28,0,0,0,1.43,38.81ZM7.69,57.69a.24.24,0,0,0,.17.4A.2.2,0,0,0,8,58a.23.23,0,0,0-.33-.33ZM7.69,32a.24.24,0,0,0,.17.4A.2.2,0,0,0,8,32.31.23.23,0,0,0,7.69,32ZM3.4,53.4a.25.25,0,0,0,0,.34.24.24,0,0,0,.34,0,.24.24,0,1,0-.34-.34Zm6.1,6.1a.7.7,0,0,0-.2.5h1.4a.7.7,0,0,0-.2-.5A.74.74,0,0,0,9.5,59.5ZM3.4,36.26a.25.25,0,0,0,0,.34.27.27,0,0,0,.34,0,.24.24,0,1,0-.34-.34Zm2.15-2.14a.24.24,0,0,0,0,.33.2.2,0,0,0,.16.07.22.22,0,0,0,.17-.07.23.23,0,1,0-.33-.33Zm0,21.43a.24.24,0,0,0,0,.33.2.2,0,0,0,.16.07.22.22,0,0,0,.17-.07.23.23,0,0,0-.33-.33ZM18.4,38.4a.25.25,0,0,0,0,.34.24.24,0,0,0,.34,0,.24.24,0,1,0-.34-.34ZM22.69,47a.24.24,0,0,0,.17.4.2.2,0,0,0,.16-.07.23.23,0,1,0-.33-.33Zm0-4.29a.24.24,0,0,0,.17.4A.2.2,0,0,0,23,43a.22.22,0,0,0,0-.33A.24.24,0,0,0,22.69,42.69ZM42,57.69A.24.24,0,0,0,42,58a.2.2,0,0,0,.16.07.23.23,0,1,0-.16-.4ZM33.4,36.26a.25.25,0,0,0,0,.34.27.27,0,0,0,.34,0,.24.24,0,0,0-.34-.34Zm15,2.14a.25.25,0,0,0,0,.34.24.24,0,0,0,.34,0,.24.24,0,0,0-.34-.34ZM39.5,59.5a.7.7,0,0,0-.2.5h1.4a.7.7,0,0,0-.2-.5A.74.74,0,0,0,39.5,59.5ZM31.43,38.81a.28.28,0,0,0,.17-.07.27.27,0,0,0,0-.34.24.24,0,1,0-.34.34A.28.28,0,0,0,31.43,38.81Zm2,14.59a.25.25,0,0,0,0,.34.24.24,0,0,0,.34,0,.24.24,0,0,0-.34-.34Zm2.15,2.15a.24.24,0,0,0,0,.33.2.2,0,0,0,.16.07.22.22,0,0,0,.17-.07.23.23,0,0,0-.33-.33ZM46.43,36.66a.2.2,0,0,0,.16-.07.23.23,0,1,0-.16.07ZM35.55,34.12a.24.24,0,0,0,0,.33.2.2,0,0,0,.16.07.22.22,0,0,0,.17-.07.23.23,0,1,0-.33-.33ZM46.26,53.4a.25.25,0,0,0,0,.34.24.24,0,0,0,.34,0,.24.24,0,0,0-.34-.34ZM37.69,32a.24.24,0,0,0,.17.4.2.2,0,0,0,.16-.07.23.23,0,1,0-.33-.33ZM48.4,51.26a.25.25,0,0,0,0,.34.27.27,0,0,0,.34,0,.24.24,0,0,0-.34-.34ZM37.69,57.69a.24.24,0,0,0,.17.4A.2.2,0,0,0,38,58a.23.23,0,0,0-.33-.33Zm6.43-2.14a.24.24,0,0,0,0,.33.22.22,0,0,0,.17.07.2.2,0,0,0,.16-.07.23.23,0,0,0-.33-.33Zm6.43-15a.24.24,0,0,0,0,.33.2.2,0,0,0,.16.07.22.22,0,0,0,.17-.07.23.23,0,0,0-.33-.33ZM25,44.3h0a.72.72,0,0,0-.5.2.91.91,0,0,0-.15.23.86.86,0,0,0-.05.27.74.74,0,0,0,.2.5.77.77,0,0,0,.5.2h0a.77.77,0,0,0,.5-.2.74.74,0,0,0,.2-.5.7.7,0,0,0-.2-.5A.72.72,0,0,0,25,44.3ZM27,47a.24.24,0,0,0,0,.33.2.2,0,0,0,.16.07A.23.23,0,1,0,27,47Zm25.71,0a.24.24,0,0,0,.17.4.2.2,0,0,0,.16-.07.23.23,0,1,0-.33-.33ZM44.12,34.12a.24.24,0,0,0,0,.33.22.22,0,0,0,.17.07.2.2,0,0,0,.16-.07.23.23,0,0,0-.33-.33Zm8.57,8.57a.24.24,0,0,0,.17.4A.2.2,0,0,0,53,43a.22.22,0,0,0,0-.33A.24.24,0,0,0,52.69,42.69ZM27,42.69A.24.24,0,0,0,27,43a.2.2,0,0,0,.16.07.23.23,0,1,0-.16-.4Zm23.57,6.43a.24.24,0,0,0,0,.33.2.2,0,0,0,.16.07.22.22,0,0,0,.17-.07.23.23,0,1,0-.33-.33ZM29.12,40.55a.24.24,0,0,0,0,.33.22.22,0,0,0,.17.07.2.2,0,0,0,.16-.07.23.23,0,0,0-.33-.33ZM42,32a.24.24,0,0,0,.16.4.28.28,0,0,0,.17-.07.24.24,0,0,0,0-.33A.22.22,0,0,0,42,32ZM29.12,49.12a.24.24,0,0,0,0,.33.22.22,0,0,0,.17.07.2.2,0,0,0,.16-.07.23.23,0,1,0-.33-.33Zm2.14,2.14a.25.25,0,0,0,0,.34.27.27,0,0,0,.34,0,.24.24,0,0,0-.34-.34Zm27.86-2.14a.24.24,0,0,0,0,.33.22.22,0,0,0,.17.07.2.2,0,0,0,.16-.07.23.23,0,0,0-.33-.33ZM55,44.3h0a.72.72,0,0,0-.5.2.91.91,0,0,0-.15.23.86.86,0,0,0-.05.27.74.74,0,0,0,.2.5.77.77,0,0,0,.5.2h0a.77.77,0,0,0,.5-.2.74.74,0,0,0,.2-.5.7.7,0,0,0-.2-.5A.72.72,0,0,0,55,44.3ZM57,47a.24.24,0,0,0,0,.33.2.2,0,0,0,.16.07A.23.23,0,1,0,57,47Zm0-4.29A.24.24,0,0,0,57,43a.2.2,0,0,0,.16.07.23.23,0,1,0-.16-.4Zm19.45-6a.2.2,0,0,0,.16-.07.23.23,0,1,0-.16.07Zm-8.74,21a.24.24,0,0,0,.17.4A.2.2,0,0,0,68,58a.23.23,0,0,0-.33-.33ZM72,32a.24.24,0,0,0,.16.4.28.28,0,0,0,.17-.07.24.24,0,0,0,0-.33A.22.22,0,0,0,72,32Zm-6.43,2.14a.24.24,0,0,0,0,.33.2.2,0,0,0,.16.07.22.22,0,0,0,.17-.07.23.23,0,1,0-.33-.33Zm0,21.43a.24.24,0,0,0,0,.33.2.2,0,0,0,.16.07.22.22,0,0,0,.17-.07.23.23,0,1,0-.33-.33Zm8.57,0a.24.24,0,0,0,0,.33.22.22,0,0,0,.17.07.2.2,0,0,0,.16-.07.23.23,0,0,0-.33-.33Zm-4.62,4a.7.7,0,0,0-.2.5h1.4a.7.7,0,0,0-.2-.5A.74.74,0,0,0,69.5,59.5Zm-10.38-19a.24.24,0,0,0,0,.33.22.22,0,0,0,.17.07.2.2,0,0,0,.16-.07.23.23,0,0,0-.33-.33ZM72,57.69A.24.24,0,0,0,72,58a.2.2,0,0,0,.16.07.23.23,0,1,0-.16-.4ZM67.69,32a.24.24,0,0,0,.17.4.2.2,0,0,0,.16-.07.23.23,0,0,0-.33-.33Zm6.43,2.14a.24.24,0,0,0,0,.33.22.22,0,0,0,.17.07.2.2,0,0,0,.16-.07.23.23,0,0,0-.33-.33ZM78.4,51.26a.25.25,0,0,0,0,.34.27.27,0,0,0,.34,0,.24.24,0,0,0-.34-.34Zm-17.14,0a.25.25,0,0,0,0,.34.27.27,0,0,0,.34,0,.24.24,0,0,0-.34-.34Zm.17-12.45a.28.28,0,0,0,.17-.07.27.27,0,0,0,0-.34.24.24,0,0,0-.34.34A.28.28,0,0,0,61.43,38.81Zm17-.41a.25.25,0,0,0,0,.34.24.24,0,0,0,.34,0,.24.24,0,0,0-.34-.34Zm-15,15a.25.25,0,0,0,0,.34.24.24,0,0,0,.34,0,.24.24,0,0,0-.34-.34Zm0-17.14a.25.25,0,0,0,0,.34.27.27,0,0,0,.34,0,.24.24,0,0,0-.34-.34ZM76.26,53.4a.25.25,0,0,0,0,.34.24.24,0,0,0,.34,0,.24.24,0,1,0-.34-.34Z"/>',
			),
			'width'      => '128px',
			'height'     => '128px',
		);
	}
}

return new ET_Builder_Pattern_Tufted();
